#include <bits/stdc++.h>
using namespace std;

struct Takmicar {
    int x, y;
    int dx, dy; // smer kretanja
};

// Funkcija koja vraca broj svih pozdrava
long long ukupnoPozdrava(const vector<pair<int,int>>& tacke) {
    vector<Takmicar> svi;

    // Kreiramo sve takmicare
    for(auto& t : tacke) {
        int x = t.first, y = t.second;
        svi.push_back({x, y, 0, 1});  // Sever
        svi.push_back({x, y, 0, -1}); // Jug
        svi.push_back({x, y, 1, 0});  // Istok
        svi.push_back({x, y, -1, 0}); // Zapad
    }

    long long pozdravi = 0;

    // Racunamo susrete svih parova takmicara
    for(size_t i = 0; i < svi.size(); i++) {
        for(size_t j = i+1; j < svi.size(); j++) {
            int dx = svi[j].dx - svi[i].dx;
            int dy = svi[j].dy - svi[i].dy;
            int xdiff = svi[i].x - svi[j].x;
            int ydiff = svi[i].y - svi[j].y;

            // Ako se kretanja poklapaju, pozdrav samo na pocetku ako su iste koordinate
            if(dx == 0 && dy == 0) {
                if(xdiff == 0 && ydiff == 0) pozdravi++;
                continue;
            }

            // Tražimo vreme t kada se sretnu:
            // dx * t = xdiff  i dy * t = ydiff
            // Moraju biti isti t i celobrojni
            if(dx == 0) {
                if(xdiff != 0) continue; // nikad se ne sretnu
                if(dy != 0 && ydiff % dy == 0 && ydiff / dy >= 0) pozdravi++;
            } else if(dy == 0) {
                if(ydiff != 0) continue;
                if(dx != 0 && xdiff % dx == 0 && xdiff / dx >= 0) pozdravi++;
            } else {
                if(xdiff % dx != 0 || ydiff % dy != 0) continue;
                int tx = xdiff / dx;
                int ty = ydiff / dy;
                if(tx == ty && tx >= 0) pozdravi++;
            }
        }
    }

    return pozdravi;
}

int main() {
    int n;
    cin >> n;
    vector<pair<int,int>> tacke(n);
    for(int i = 0; i < n; i++) {
        cin >> tacke[i].first >> tacke[i].second;
    }

    cout << ukupnoPozdrava(tacke) << endl;
    return 0;
}